/*	extent.c	1.7	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"
#include "cpmfio.h"

/*
 * Allocate a new extent to the file pointed to by curext,
 * or, if curext < 0, return the index of the first free
 * directory slot.
 * Return a negative pointer if no directory space, otherwise
 * the index to the new extent.
 */

cpm_creext(struct cpmfs *cpmfs, int curext)
{
	int i, j;

	for (i=0; i < cpmfs->maxdir; i++)
		if ((cpmfs->dirbuf + i)->status == (char) 0xe5) 
			break;
	if (i == cpmfs->maxdir) 
		return (EOF);
	if (curext >= 0) 
		*(cpmfs->dirbuf+i) = *(cpmfs->dirbuf+curext);
	
	/* clear all file pointers */
	for (j=0; j<16; j++)
		(cpmfs->dirbuf+i)->pointers[j] = '\0';

#ifdef DEBUG
	printf("extent allocated: %d (old: %d)\n", i, curext);
	printf("extent data: 0x%x, name: %s\n", (cpmfs->dirbuf+i)->status,
			(cpmfs->dirbuf+i)->name);
#endif
	return(i);
}


/*
 * Find next extent of the file pointed to by file pointer 'current',
 * return the new extent's index if found, otherwise -1.
 */

cpm_getnext(C_FILE *cur)
{

	int	ind;

	cur->c_extno++;
	for (ind = 0; ind < cur->cpmfs->maxdir; ind++) 
		if ((strncmp(cur->c_dirp->name,(cur->cpmfs->dirbuf+ind)->name,8)==0) &&
		    (strncmp((cur->cpmfs->dirbuf+ind)->ext, cur->c_dirp->ext,3)==0) &&
		    ((cur->cpmfs->dirbuf+ind)->extno == cur->c_extno)) {
			cur->c_ext=ind;
			cur->c_seccnt =
				((0xff & (int)(cur->cpmfs->dirbuf+ind)->blkcnt)
				 + (cur->cpmfs->seclth/CPMSECSIZ) - 1)
				/ (cur->cpmfs->seclth/CPMSECSIZ);
			cur->c_dirp = cur->cpmfs->dirbuf + ind;
			cur->c_blk = 0;
#ifdef DEBUG
			printf("getnext: dir. index: %d\n",ind); 
#endif
			return (ind);
		}
	return (-1);
}
